/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import sun.plugin.usability.ProgressTracker;

public class ProgressInputStream
extends InputStream {
    private int progressStep = 8192;
    private InputStream is = null;
    private int curPos = 0;
    private int markPos = 0;
    private int total = -1;
    private boolean bStartBinding = false;
    private URLConnection conn = null;
    private String url = null;
    private int lastProgress = 0;

    public int available() throws IOException {
        return this.is.available();
    }

    public int read() throws IOException {
        int n = this.is.read();
        this.updateProgress(1);
        return n;
    }

    public synchronized void close() throws IOException {
        this.is.close();
        if (this.bStartBinding) {
            this.bStartBinding = false;
            ProgressTracker.onProgressAvailable(this.url, this.curPos, this.total);
            ProgressTracker.onStopBinding(this.url);
        }
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
        this.curPos = this.markSupported() ? this.markPos : 0;
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public synchronized void mark(int n) {
        this.is.mark(n);
        if (this.markSupported()) {
            this.markPos = this.curPos;
        }
    }

    private synchronized void updateProgress(int n) {
        if (n != -1) {
            if (!this.bStartBinding) {
                this.bStartBinding = true;
                this.total = this.conn.getContentLength();
                ProgressTracker.onStartBinding(this.url);
            }
            this.curPos += n;
            if (this.curPos / this.progressStep > this.lastProgress) {
                this.lastProgress = this.curPos / this.progressStep;
                ProgressTracker.onProgressAvailable(this.url, this.curPos, this.total);
            }
        }
    }

    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.is.read(byArray);
        this.updateProgress(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        this.updateProgress(n3);
        return n3;
    }

    public ProgressInputStream(InputStream inputStream, URLConnection uRLConnection) {
        this.is = inputStream;
        this.conn = uRLConnection;
        this.url = uRLConnection.getURL().toString();
    }
}

