/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.plugin.usability.PluginSysAction;
import sun.plugin.usability.PluginSysUtil;
import sun.security.action.GetPropertyAction;

public final class PluginSysUtil {
    private static EventQueue pluginEventQueue = null;
    private static ThreadGroup pluginThreadGroup = null;
    private static ClassLoader pluginSysClassLoader = null;

    private static boolean isOnWindows() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        return string.indexOf("Windows") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        AWTInvocationLock aWTInvocationLock2 = aWTInvocationLock;
        synchronized (aWTInvocationLock2) {
            pluginEventQueue.postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        Exception exception = invocationEvent.getException();
        if (exception != null) {
            throw new InvocationTargetException(exception);
        }
    }

    public static void invokeLater(Runnable runnable) {
        pluginEventQueue.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    static ThreadGroup access$100() {
        return pluginThreadGroup;
    }

    public static synchronized ThreadGroup getPluginThreadGroup() {
        if (pluginThreadGroup == null) {
            pluginSysClassLoader = Thread.currentThread().getContextClassLoader();
            pluginThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Plugin Thread Group");
            PluginSysUtil.createAppContext(pluginThreadGroup);
        }
        return pluginThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAppContext(ThreadGroup threadGroup) {
        AppContextCreatorThread appContextCreatorThread = new AppContextCreatorThread(threadGroup);
        Object object = appContextCreatorThread.synObject;
        synchronized (object) {
            appContextCreatorThread.start();
            try {
                appContextCreatorThread.synObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static EventQueue access$002(EventQueue eventQueue) {
        pluginEventQueue = eventQueue;
        return pluginEventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object execute(PluginSysAction pluginSysAction) throws Exception {
        if (Thread.currentThread().getThreadGroup().equals(pluginThreadGroup)) {
            return pluginSysAction.execute();
        }
        SysExecutionThread sysExecutionThread = new SysExecutionThread(pluginSysAction);
        sysExecutionThread.setContextClassLoader(pluginSysClassLoader);
        if (SwingUtilities.isEventDispatchThread()) {
            Object object = sysExecutionThread.syncObject;
            synchronized (object) {
                block14: {
                    DummyDialog dummyDialog;
                    sysExecutionThread.theDummy = dummyDialog = new DummyDialog(null, true);
                    dummyDialog.addWindowListener(new WindowAdapter(sysExecutionThread, dummyDialog){
                        private final SysExecutionThread val$t;
                        private final DummyDialog val$dummy;

                        public void windowClosing(WindowEvent windowEvent) {
                            this.val$dummy.hide();
                        }

                        public void windowOpened(WindowEvent windowEvent) {
                            this.val$t.start();
                        }
                        {
                            this.val$t = sysExecutionThread;
                            this.val$dummy = dummyDialog;
                        }
                    });
                    Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                    if (!PluginSysUtil.isOnWindows()) {
                        dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
                    } else {
                        dummyDialog.setLocation(-100, -100);
                    }
                    dummyDialog.setResizable(false);
                    dummyDialog.toBack();
                    dummyDialog.show();
                    try {
                        try {
                            sysExecutionThread.syncObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Object var7_7 = null;
                            dummyDialog.hide();
                            break block14;
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        dummyDialog.hide();
                        throw throwable;
                    }
                    dummyDialog.hide();
                }
            }
        } else {
            sysExecutionThread.start();
            try {
                sysExecutionThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (sysExecutionThread.exception != null) {
            throw sysExecutionThread.exception;
        }
        return sysExecutionThread.result;
    }

    public static Thread createPluginSysThread(Runnable runnable) {
        Thread thread = new Thread(pluginThreadGroup, runnable);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public static Thread createPluginSysThread(Runnable runnable, String string) {
        Thread thread = new Thread(pluginThreadGroup, runnable, string);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    private static class AppContextCreatorThread
    extends Thread {
        Object synObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.synObject;
            synchronized (object) {
                AppContext appContext = SunToolkit.createNewAppContext();
                PluginSysUtil.access$002((EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY));
                this.synObject.notifyAll();
            }
        }

        public AppContextCreatorThread(ThreadGroup threadGroup) {
            super(threadGroup, "AppContext Creator Thread");
        }
    }

    private static class DummyDialog
    extends JDialog {
        private ThreadGroup _unsecureGroup = Thread.currentThread().getThreadGroup();

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(this){
                private final DummyDialog this$0;

                public void run() {
                    this.this$0.hide();
                }
                {
                    this.this$0 = dummyDialog;
                }
            }).start();
        }

        DummyDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }
    }

    static class SysExecutionThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        PluginSysAction action = null;
        Object syncObject = new Object();
        DummyDialog theDummy = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.result = this.action.execute();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            finally {
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                Object object = this.syncObject;
                synchronized (object) {
                    this.syncObject.notifyAll();
                }
            }
        }

        public SysExecutionThread(PluginSysAction pluginSysAction) {
            super(PluginSysUtil.access$100(), "SysExecutionThead");
            this.action = pluginSysAction;
        }
    }
}

