/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;

public class HttpsRootCACertStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _jssecacerts = null;

    static {
        _filename = UserProfile.getHttpsRootCertFile();
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.loading", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                private final HttpsRootCACertStore this$0;

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (HttpsRootCACertStore.access$000(this.this$0) == null) {
                        HttpsRootCACertStore.access$002(this.this$0, KeyStore.getInstance("JKS"));
                        HttpsRootCACertStore.access$000(this.this$0).load(null, null);
                    }
                    if ((file = new File(HttpsRootCACertStore.access$100())).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        HttpsRootCACertStore.access$000(this.this$0).load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else {
                        Trace.msgSecurityPrintln("roothttpscertstore.cert.noload", new Object[]{HttpsRootCACertStore.access$100()});
                    }
                    return null;
                }
                {
                    this.this$0 = httpsRootCACertStore;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("roothttpscertstore.cert.loaded", new Object[]{_filename});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.saving", new Object[]{_filename});
    }

    static String access$100() {
        return _filename;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.adding");
        throw new KeyStoreException("Cannot add Https root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.removing");
        throw new KeyStoreException("Cannot remove Https root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.instore");
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.canverify");
        Trace.msgSecurityPrintln("roothttpscertstore.cert.tobeverified", new Object[]{certificate});
        Enumeration<String> enumeration = this._jssecacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._jssecacerts.getCertificate(string);
            Trace.msgSecurityPrintln("roothttpscertstore.cert.tobecompared", new Object[]{certificate2});
            try {
                certificate.verify(certificate2.getPublicKey());
                Trace.msgSecurityPrintln("roothttpscertstore.cert.verify.ok");
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.msgSecurityPrintln("roothttpscertstore.cert.verify.fail");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.iterator");
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._jssecacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._jssecacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    static KeyStore access$000(HttpsRootCACertStore httpsRootCACertStore) {
        return httpsRootCACertStore._jssecacerts;
    }

    static KeyStore access$002(HttpsRootCACertStore httpsRootCACertStore, KeyStore keyStore) {
        httpsRootCACertStore._jssecacerts = keyStore;
        return httpsRootCACertStore._jssecacerts;
    }
}

