/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;

public class Broken11ClassFixer {
    private byte[] src;
    private int srcPos;
    private byte[] dest;
    private int destPos;
    private int numConstantPoolEntries;
    private boolean detectedBogusLocalVariableNameIndex;
    private static final int CODE_MASK = 1;
    private static final int LOCAL_VARIABLE_TABLE_MASK = 2;
    private byte[] constantPoolUtf8Entries;
    private static final int CONSTANT_CLASS_TAG = 7;
    private static final int CONSTANT_FIELD_REF_TAG = 9;
    private static final int CONSTANT_METHOD_REF_TAG = 10;
    private static final int CONSTANT_INTERFACE_METHOD_REF_TAG = 11;
    private static final int CONSTANT_STRING_TAG = 8;
    private static final int CONSTANT_INTEGER_TAG = 3;
    private static final int CONSTANT_FLOAT_TAG = 4;
    private static final int CONSTANT_LONG_TAG = 5;
    private static final int CONSTANT_DOUBLE_TAG = 6;
    private static final int CONSTANT_NAME_AND_TYPE_TAG = 12;
    private static final int CONSTANT_UTF8_TAG = 1;

    private int copyByte() {
        int n = this.readByte();
        this.writeByte(n);
        return n;
    }

    private int copyInt() {
        int n = this.readInt();
        this.writeInt(n);
        return n;
    }

    private int copyShort() {
        int n = this.readShort();
        this.writeShort(n);
        return n;
    }

    private int destPos() {
        return this.destPos;
    }

    public int getProcessedDataLength() {
        return this.destPos;
    }

    public int getProcessedDataOffset() {
        return 0;
    }

    private int readByte() {
        return this.src[this.srcPos++] & 0xFF;
    }

    private int readInt() {
        int n = this.readShort();
        int n2 = this.readShort();
        return n << 16 | n2;
    }

    private int readShort() {
        int n = this.readByte();
        int n2 = this.readByte();
        return n << 8 | n2;
    }

    private int srcPos() {
        return this.srcPos;
    }

    private void copyAccessFlagsAndClassInformation() {
        this.copy(6);
    }

    private void copyAttribute() {
        this.copy(2);
        this.copyRestOfAttribute();
    }

    private void copyAttributes() {
        int n = this.copyShort();
        int n2 = 0;
        while (n2 < n) {
            this.copyAttribute();
            ++n2;
        }
    }

    private void copyHeader() {
        this.copy(8);
    }

    private void copyInterfaces() {
        int n = this.copyShort();
        this.copy(2 * n);
    }

    private void copyRestOfAttribute() {
        this.copy(this.copyInt());
    }

    private void processCodeAttribute() {
        int n = this.destPos();
        int n2 = this.copyInt();
        this.copy(4);
        int n3 = this.copyInt();
        this.copy(n3);
        this.copy(8 * this.copyShort());
        int n4 = this.copyShort();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.copyShort();
            if (this.cpIdxIsLocalVariableTable(n6)) {
                this.processLocalVariableTableAttribute(n, n2, n3);
            } else {
                this.copyRestOfAttribute();
            }
            ++n5;
        }
    }

    private void scanAndCopyAccessFlags() {
        int n = this.readShort();
        n = Modifier.isPublic(n) ? (n &= 0xFFFFFFF9) : (Modifier.isProtected(n) ? (n &= 0xFFFFFFFC) : (n &= 0xFFFFFFFA));
        this.writeShort(n);
    }

    private void scanAndCopyConstantPool() {
        this.numConstantPoolEntries = this.copyShort() - 1;
        this.constantPoolUtf8Entries = new byte[this.numConstantPoolEntries];
        int n = 0;
        while (n < this.numConstantPoolEntries) {
            int n2 = this.copyByte();
            switch (n2) {
                case 7: 
                case 8: {
                    this.copy(2);
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.copy(4);
                    break;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++n;
                    break;
                }
                case 1: {
                    this.scanAndCopyUtf8(n);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid constant pool tag " + n2);
                }
            }
            ++n;
        }
    }

    private void scanAndCopyFields() {
        int n = this.copyShort();
        int n2 = 0;
        while (n2 < n) {
            this.scanAndCopyAccessFlags();
            this.copy(4);
            this.copyAttributes();
            ++n2;
        }
    }

    private void scanAndCopyMethods() {
        int n = this.copyShort();
        int n2 = 0;
        while (n2 < n) {
            this.scanAndCopyAccessFlags();
            this.copy(4);
            int n3 = this.copyShort();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.copyShort();
                if (this.cpIdxIsCode(n5)) {
                    this.processCodeAttribute();
                } else {
                    this.copyRestOfAttribute();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void usage() {
        System.err.println("Usage: java Broken11ClassFixer [filename]");
        System.exit(1);
    }

    public byte[] getProcessedData() {
        return this.dest;
    }

    private void copy(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.dest[this.destPos + n2] = this.src[this.srcPos + n2];
            ++n2;
        }
        this.srcPos += n;
        this.destPos += n;
    }

    private void markCodeInCP(int n) {
        int n2 = n;
        this.constantPoolUtf8Entries[n2] = (byte)(this.constantPoolUtf8Entries[n2] | 1);
    }

    private void markLocalVariableTableInCP(int n) {
        int n2 = n;
        this.constantPoolUtf8Entries[n2] = (byte)(this.constantPoolUtf8Entries[n2] | 2);
    }

    private void scanAndCopyUtf8(int n) {
        int n2 = this.copyShort();
        String string = "Code";
        String string2 = "LocalVariableTable";
        if (n2 == string.length()) {
            if (this.copyUtf8LookingFor(string)) {
                this.markCodeInCP(n);
            }
        } else if (n2 == string2.length()) {
            if (this.copyUtf8LookingFor(string2)) {
                this.markLocalVariableTableInCP(n);
            }
        } else {
            this.copy(n2);
        }
    }

    private void writeByte(int n) {
        this.dest[this.destPos++] = (byte)n;
    }

    private void writeInt(int n) {
        this.writeShort(n >> 16);
        this.writeShort(n);
    }

    private void writeShort(int n) {
        this.writeByte(n >> 8);
        this.writeByte(n);
    }

    private boolean cpIdxIsCode(int n) {
        return (this.constantPoolUtf8Entries[n - 1] & 1) != 0;
    }

    private boolean cpIdxIsLocalVariableTable(int n) {
        return (this.constantPoolUtf8Entries[n - 1] & 2) != 0;
    }

    private boolean isValidConstantPoolIndex(int n) {
        return n > 0 && n <= this.numConstantPoolEntries;
    }

    private void writeByteAt(int n, int n2) {
        this.dest[n] = (byte)n2;
    }

    private void writeIntAt(int n, int n2) {
        this.writeShortAt(n, n2 >> 16);
        this.writeShortAt(n + 2, n2);
    }

    private void writeShortAt(int n, int n2) {
        this.writeByteAt(n, n2 >> 8);
        this.writeByteAt(n + 1, n2);
    }

    private void processLocalVariableTableAttribute(int n, int n2, int n3) {
        int n4;
        int n5 = this.destPos();
        int n6 = this.copyInt();
        int n7 = this.destPos();
        int n8 = n4 = this.copyShort();
        int n9 = 0;
        while (n9 < n4) {
            int n10 = this.readShort();
            int n11 = this.readShort();
            int n12 = this.readShort();
            int n13 = this.readShort();
            int n14 = this.readShort();
            if (this.isValidConstantPoolIndex(n12) && this.isValidStartAndLength(n10, n11, n3)) {
                this.writeShort(n10);
                this.writeShort(n11);
                this.writeShort(n12);
                this.writeShort(n13);
                this.writeShort(n14);
            } else {
                this.writeIntAt(n, n2 -= 10);
                this.writeIntAt(n5, n6 -= 10);
                this.writeShortAt(n7, --n8);
                this.detectedBogusLocalVariableNameIndex = true;
            }
            ++n9;
        }
    }

    private boolean isValidStartAndLength(int n, int n2, int n3) {
        return n >= 0 && n + n2 <= n3;
    }

    private void init(byte[] byArray, int n, int n2) {
        this.src = byArray;
        this.srcPos = n;
        this.dest = new byte[n2];
        this.destPos = 0;
        this.detectedBogusLocalVariableNameIndex = false;
    }

    public void process(byte[] byArray, int n, int n2) throws Exception {
        this.init(byArray, n, n2);
        this.copyHeader();
        this.scanAndCopyConstantPool();
        this.copyAccessFlagsAndClassInformation();
        this.copyInterfaces();
        this.scanAndCopyFields();
        this.scanAndCopyMethods();
        this.copyAttributes();
    }

    private boolean copyUtf8LookingFor(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.copyByte();
            if (n3 != (string.charAt(n2) & 0xFF)) {
                this.copy(n - n2 - 1);
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Broken11ClassFixer.usage();
        }
        try {
            File file = new File(stringArray[0]);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n2 = 0;
            while (n2 < byArray.length) {
                n2 += bufferedInputStream.read(byArray, n2, byArray.length - n2);
            }
            Broken11ClassFixer broken11ClassFixer = new Broken11ClassFixer();
            broken11ClassFixer.process(byArray, 0, byArray.length);
            if (broken11ClassFixer.detectedBogusLocalVariableNameIndex) {
                System.err.println("Detected bogus local variable name index");
            }
            if (broken11ClassFixer.srcPos < byArray.length) {
                System.err.println("Detected extra bytes at the end of the class file");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

