/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.Font;
import java.awt.Panel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import sun.plugin.cache.Cache;
import sun.plugin.cache.FileType;
import sun.plugin.cache.JarCacheViewer;
import sun.plugin.resources.ResourceHandler;

class JarCacheEntry {
    public static final String NAME = ResourceHandler.getMessage("cache_viewer.name");
    public static final String TYPE = ResourceHandler.getMessage("cache_viewer.type");
    public static final String SIZE = ResourceHandler.getMessage("cache_viewer.size");
    public static final String MODIFY_DATE = ResourceHandler.getMessage("cache_viewer.modify_date");
    public static final String EXPIRY_DATE = ResourceHandler.getMessage("cache_viewer.expiry_date");
    public static final String VERSION = ResourceHandler.getMessage("cache_viewer.version");
    public static final String URL = ResourceHandler.getMessage("cache_viewer.url");
    public static final String NAME_HELP = ResourceHandler.getMessage("cache_viewer.help.name");
    public static final String TYPE_HELP = ResourceHandler.getMessage("cache_viewer.help.type");
    public static final String SIZE_HELP = ResourceHandler.getMessage("cache_viewer.help.size");
    public static final String MODIFY_DATE_HELP = ResourceHandler.getMessage("cache_viewer.help.modify_date");
    public static final String EXPIRY_DATE_HELP = ResourceHandler.getMessage("cache_viewer.help.expiry_date");
    public static final String VERSION_HELP = ResourceHandler.getMessage("cache_viewer.help.version");
    public static final String URL_HELP = ResourceHandler.getMessage("cache_viewer.help.url");
    private String url;
    private long expiration = 0L;
    private long lastModified = 0L;
    String version = null;
    private File indexFile = null;
    private File dataFile = null;

    JarCacheEntry() {
    }

    public boolean delete() {
        boolean bl = this.dataFile.delete();
        if (bl) {
            this.dataFile = null;
            if (this.indexFile.delete()) {
                this.indexFile = null;
            }
        }
        return bl;
    }

    public String getExpiration() {
        return this.formatDate(this.expiration);
    }

    public String getFileExtenstion() {
        return FileType.getFileDescription(Cache.getFileExtension(this.url));
    }

    public String getLastModifyDate() {
        return this.formatDate(this.lastModified);
    }

    public String getName() {
        return this.dataFile.getName();
    }

    public String getSize() {
        long l = 0L;
        long l2 = this.dataFile.length();
        if (l2 - (l = l2 / 1024L) * 1024L > 0L) {
            ++l;
        }
        return new Long(l).toString();
    }

    public String getURL() {
        return this.url;
    }

    public String getVersion() {
        if (this.version == null || this.version.equals("x.x.x.x")) {
            this.version = "N/A";
        }
        return this.version;
    }

    private String formatDate(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy hh:mm a");
        Date date = new Date(l);
        return simpleDateFormat.format(date);
    }

    public static LinkedList getEntries() {
        LinkedList linkedList = new LinkedList();
        String string = File.separator;
        File file = new File(JarCacheViewer.getCacheLocation() + string + "jar" + string + "1.0");
        JarCacheEntry.getFileEntries(file, linkedList);
        File file2 = new File(JarCacheViewer.getCacheLocation() + string + "file" + string + "1.0");
        JarCacheEntry.getFileEntries(file2, linkedList);
        return linkedList;
    }

    static long access$302(JarCacheEntry jarCacheEntry, long l) {
        jarCacheEntry.lastModified = l;
        return jarCacheEntry.lastModified;
    }

    static long access$402(JarCacheEntry jarCacheEntry, long l) {
        jarCacheEntry.expiration = l;
        return jarCacheEntry.expiration;
    }

    public Object getDisplayValue(String string) {
        String string2 = null;
        if (string.equals(URL)) {
            string2 = this.getURL();
        } else if (string.equals(EXPIRY_DATE)) {
            string2 = this.getExpiration();
        } else if (string.equals(MODIFY_DATE)) {
            string2 = this.getLastModifyDate();
        } else if (string.equals(VERSION)) {
            string2 = this.getVersion();
        } else if (string.equals(SIZE)) {
            string2 = this.getSize() + "KB";
        } else if (string.equals(NAME)) {
            string2 = this.getName();
        } else if (string.equals(TYPE)) {
            string2 = this.getFileExtenstion();
        }
        return string2;
    }

    public Object getValue(String string) {
        Object object = null;
        if (string.equals(URL)) {
            object = this.getURL();
        } else if (string.equals(EXPIRY_DATE)) {
            object = new Date(this.expiration);
        } else if (string.equals(MODIFY_DATE)) {
            object = new Date(this.lastModified);
        } else if (string.equals(VERSION)) {
            object = this.getVersion();
        } else if (string.equals(SIZE)) {
            object = new Long(this.dataFile.length());
        } else if (string.equals(NAME)) {
            object = this.getName();
        } else if (string.equals(TYPE)) {
            object = this.getFileExtenstion();
        }
        return object;
    }

    private static final Object privileged(CacheIOAction cacheIOAction) throws IOException {
        try {
            return AccessController.doPrivileged(cacheIOAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public static int getTextWidth(Font font, String string) {
        Panel panel = new Panel();
        String string2 = "";
        if (string.equals(URL)) {
            string2 = "http://java.sun.com/javaweb/products/plugin/swingapplet.html";
        } else if (string.equals(EXPIRY_DATE) || string.equals(MODIFY_DATE)) {
            string2 = "12/13/69 04:00 PM  ";
        } else if (string.equals(VERSION)) {
            string2 = "Version    ";
        } else if (string.equals(SIZE)) {
            string2 = "999,999KB ";
        } else if (string.equals(NAME)) {
            string2 = "test-images.jar-2bc62790-5ad1049d";
        } else if (string.equals(TYPE)) {
            string2 = "Jpeg Image  ";
        }
        return panel.getFontMetrics(font).stringWidth(string2);
    }

    static String access$200(JarCacheEntry jarCacheEntry) {
        return jarCacheEntry.url;
    }

    private static void getFileEntries(File file, LinkedList linkedList) {
        if (file.exists()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    return string.toLowerCase().endsWith(".idx");
                }
            });
            int n = 0;
            while (n < fileArray.length) {
                JarCacheEntry jarCacheEntry = null;
                try {
                    jarCacheEntry = JarCacheEntry.getDetails(fileArray[n]);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    jarCacheEntry = null;
                }
                if (jarCacheEntry != null) {
                    linkedList.add(jarCacheEntry);
                }
                ++n;
            }
        }
    }

    private static JarCacheEntry getDetails(File file) throws IOException {
        return (JarCacheEntry)JarCacheEntry.privileged(new CacheIOAction(file){
            private final File val$f;
            {
                this.val$f = file;
                super(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws IOException {
                JarCacheEntry jarCacheEntry = null;
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.val$f, "r");
                try {
                    if (randomAccessFile.readByte() == 16) {
                        File file;
                        jarCacheEntry = new JarCacheEntry();
                        JarCacheEntry.access$102(jarCacheEntry, this.val$f);
                        JarCacheEntry.access$202(jarCacheEntry, randomAccessFile.readUTF());
                        JarCacheEntry.access$302(jarCacheEntry, randomAccessFile.readLong());
                        JarCacheEntry.access$402(jarCacheEntry, randomAccessFile.readLong());
                        int n = randomAccessFile.readInt();
                        if (n == 1) {
                            jarCacheEntry.version = randomAccessFile.readUTF();
                        }
                        if ((file = Cache.getDataFile(this.val$f, JarCacheEntry.access$200(jarCacheEntry))).exists()) {
                            JarCacheEntry.access$502(jarCacheEntry, file);
                        } else {
                            jarCacheEntry = null;
                        }
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (IOException iOException) {}
                return jarCacheEntry;
            }
        });
    }

    static File access$102(JarCacheEntry jarCacheEntry, File file) {
        jarCacheEntry.indexFile = file;
        return jarCacheEntry.indexFile;
    }

    static File access$502(JarCacheEntry jarCacheEntry, File file) {
        jarCacheEntry.dataFile = file;
        return jarCacheEntry.dataFile;
    }

    static String access$202(JarCacheEntry jarCacheEntry, String string) {
        jarCacheEntry.url = string;
        return jarCacheEntry.url;
    }

    private static class CacheIOAction
    implements PrivilegedExceptionAction {
        private CacheIOAction() {
        }

        public Object run() throws IOException {
            return null;
        }

        CacheIOAction(1 var1_1) {
            this();
        }
    }
}

