/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CacheFile;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.JarCache;
import sun.plugin.usability.UserProfile;

public class CleanupThread
extends Thread {
    private boolean cleanupRequested = false;
    private Thread thisThread = null;
    private long timeToWait = 0L;
    private long prevCacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        Object[] objectArray = this.getFilesInCache();
        int n = objectArray.length;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        while (n2 < n) {
            l2 += ((CacheFile)objectArray[n2]).getSize();
            ++n2;
        }
        l = Cache.deleteThresholdSize;
        int n3 = 0;
        while (l2 > l && n3 < n) {
            Cache.msgPrintln("cache.size", new Object[]{new Long(l2)});
            l2 -= ((CacheFile)objectArray[n3++]).delete();
        }
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.prevCacheSize = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thisThread = Thread.currentThread();
        try {
            while (true) {
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.cleanupRequested) {
                        this.cleanupRequested = false;
                        if (this.prevCacheSize > Cache.threadThresholdSize) {
                            Cache.msgPrintln("cache.cleanup", new Object[]{new Long(this.prevCacheSize).toString()});
                            this.cleanCache();
                        }
                    } else {
                        this.wait(this.timeToWait);
                        this.cleanupRequested = true;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.thisThread = null;
            return;
        }
    }

    private void setCacheSize() {
        File file;
        File[] fileArray;
        long l = 0L;
        long l2 = 0L;
        File file2 = new File(UserProfile.getNewJarCacheDir());
        if (file2.exists()) {
            fileArray = file2.listFiles();
            l2 = 0L;
            int n = 0;
            while (n < fileArray.length) {
                l2 += fileArray[n].length();
                ++n;
            }
        }
        if ((file = new File(UserProfile.getNewFileCacheDir())).exists()) {
            fileArray = file.listFiles();
            l = 0L;
            int n = 0;
            while (n < fileArray.length) {
                l += fileArray[n].length();
                ++n;
            }
        }
        this.prevCacheSize = l + l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trigger() {
        if (this.thisThread != null) {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.cleanupRequested = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedFile(long l) {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.prevCacheSize += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedJar(long l) {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.prevCacheSize += l;
        }
    }

    private Object[] getFilesInCache() {
        Object object;
        String string;
        Object[] objectArray;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        File[] fileArray = null;
        fileArray = FileCache.directory.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            String string2 = fileArray[n].getName();
            objectArray = Cache.getFileExtension(string2);
            string = string2.substring(0, string2.length() - objectArray.length()).toLowerCase();
            object = (CacheFile)hashMap.get(string);
            if (object == null) {
                object = new CacheFile(string);
                hashMap.put(string, object);
            }
            ((CacheFile)object).addFile(fileArray[n], (String)objectArray);
            ++n;
        }
        fileArray = JarCache.directory.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            objectArray = fileArray[n2].getName();
            string = Cache.getFileExtension((String)objectArray);
            object = objectArray.substring(0, objectArray.length() - string.length()).toLowerCase();
            CacheFile cacheFile = (CacheFile)hashMap.get(object);
            if (cacheFile == null) {
                cacheFile = new CacheFile((String)object);
                hashMap.put(object, cacheFile);
            }
            cacheFile.addFile(fileArray[n2], string);
            ++n2;
        }
        objectArray = hashMap.values().toArray();
        Arrays.sort(objectArray, new Comparator(this){
            private final CleanupThread this$0;
            {
                this.this$0 = cleanupThread;
            }

            public int compare(Object object, Object object2) {
                CacheFile cacheFile = (CacheFile)object;
                CacheFile cacheFile2 = (CacheFile)object2;
                if (cacheFile.before(cacheFile2)) {
                    return -1;
                }
                if (cacheFile2.before(cacheFile)) {
                    return 1;
                }
                return 0;
            }
        });
        return objectArray;
    }

    public CleanupThread(ThreadGroup threadGroup) {
        this(threadGroup, 600000L);
    }

    public CleanupThread(ThreadGroup threadGroup, long l) {
        super(threadGroup, "Cache Cleanup Thread");
        this.setPriority(4);
        this.timeToWait = l;
        this.setCacheSize();
    }
}

