/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.foreach;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.axis.tools.ant.foreach.ParamItem;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class ParamSet {
    public static final String TYPE_FILE = "file".intern();
    public static final String TYPE_DIR = "dir".intern();
    public static final String TYPE_BOTH = "both".intern();
    protected String type = TYPE_FILE;
    private Vector filesets = new Vector();
    private Vector items = new Vector();
    private String name;

    public void addFileset(FileSet fileset) {
        this.filesets.addElement(fileset);
    }

    public ParamItem createItem() {
        ParamItem item = new ParamItem();
        this.items.addElement(item);
        return item;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getValues(Project project) {
        Vector<String> values = new Vector<String>();
        Enumeration enumeration = this.filesets.elements();
        while (enumeration.hasMoreElements()) {
            File f;
            int j;
            FileSet fileSet = (FileSet)enumeration.nextElement();
            File base = fileSet.getDir(project);
            DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
            if (TYPE_DIR != this.type) {
                String[] files = this.getFiles(base, scanner);
                j = 0;
                while (j < files.length) {
                    f = new File(base, files[j]);
                    values.addElement(f.getAbsolutePath());
                    ++j;
                }
            }
            if (TYPE_FILE == this.type) continue;
            String[] dirs = this.getDirs(base, scanner);
            j = 0;
            while (j < dirs.length) {
                f = new File(base, dirs[j]);
                values.addElement(f.getAbsolutePath());
                ++j;
            }
        }
        enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            ParamItem item = (ParamItem)enumeration.nextElement();
            values.addElement(item.getValue());
        }
        return values.elements();
    }

    public void setType(FileDirBoth type) {
        this.type = type.getValue().intern();
    }

    protected String[] getFiles(File basedir, DirectoryScanner ds) {
        return ds.getIncludedFiles();
    }

    protected String[] getDirs(File basedir, DirectoryScanner ds) {
        return ds.getIncludedDirectories();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{TYPE_FILE, TYPE_DIR, TYPE_BOTH};
        }
    }
}

