/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.Pair;
import com.borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class CompositeItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemPainter firstPainter;
    protected transient ItemPainter secondPainter;
    protected Insets margins = new Insets(1, 1, 1, 1);
    protected int orientation = 0;
    protected int alignment = 34;
    protected int gap;
    protected Color background;
    protected boolean paintBackground = true;
    ItemPaintSiteDelegate delegate1 = new ItemPaintSiteDelegate(this){

        public int getAlignment() {
            int align = this.ips != null ? this.ips.getAlignment() : CompositeItemPainter.this.alignment;
            int hAlign = align & 0xF;
            int vAlign = align & 0xF0;
            if (CompositeItemPainter.this.orientation == 0) {
                if (hAlign == 2) {
                    hAlign = 3;
                }
            } else if (vAlign == 32) {
                vAlign = 48;
            }
            return hAlign | vAlign;
        }
    };
    ItemPaintSiteDelegate delegate2 = new ItemPaintSiteDelegate(this){

        public int getAlignment() {
            int align = this.ips != null ? this.ips.getAlignment() : CompositeItemPainter.this.alignment;
            int hAlign = align & 0xF;
            int vAlign = align & 0xF0;
            if (CompositeItemPainter.this.orientation == 0) {
                if (hAlign == 2) {
                    hAlign = 1;
                }
            } else if (vAlign == 32) {
                vAlign = 16;
            }
            return hAlign | vAlign;
        }
    };

    public CompositeItemPainter() {
    }

    public CompositeItemPainter(ItemPainter firstPainter, ItemPainter secondPainter) {
        this(firstPainter, secondPainter, 0, 34, 4);
    }

    public CompositeItemPainter(ItemPainter firstPainter, ItemPainter secondPainter, int orientation) {
        this(firstPainter, secondPainter, orientation, 34, 4);
    }

    public CompositeItemPainter(ItemPainter firstPainter, ItemPainter secondPainter, int orientation, int alignment) {
        this(firstPainter, secondPainter, orientation, alignment, 4);
    }

    public CompositeItemPainter(ItemPainter firstPainter, ItemPainter secondPainter, int orientation, int alignment, int gap) {
        this.firstPainter = firstPainter;
        this.secondPainter = secondPainter;
        this.orientation = orientation;
        this.alignment = alignment;
        this.gap = gap;
    }

    public void setPainter1(ItemPainter firstPainter) {
        this.firstPainter = firstPainter;
    }

    public ItemPainter getPainter1() {
        return this.firstPainter;
    }

    public void setPainter2(ItemPainter secondPainter) {
        this.secondPainter = secondPainter;
    }

    public ItemPainter getPainter2() {
        return this.secondPainter;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setPaintBackground(boolean paintBackground) {
        this.paintBackground = paintBackground;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public Dimension getPreferredSize(Object object, Graphics g, int state, ItemPaintSite site) {
        Dimension dimSecond;
        Dimension dimFirst;
        this.delegate1.ips = site;
        this.delegate2.ips = site;
        if (object instanceof Pair) {
            dimFirst = this.firstPainter.getPreferredSize(((Pair)object).first, g, state, this.delegate1);
            dimSecond = this.secondPainter.getPreferredSize(((Pair)object).second, g, state, this.delegate2);
        } else {
            dimFirst = this.firstPainter.getPreferredSize(object, g, state, this.delegate1);
            dimSecond = this.secondPainter.getPreferredSize(object, g, state, this.delegate2);
        }
        if (this.orientation == 0) {
            return new Dimension(dimFirst.width + this.gap + dimSecond.width + this.margins.left + this.margins.right, Math.max(dimFirst.height, dimSecond.height) + this.margins.top + this.margins.bottom);
        }
        return new Dimension(Math.max(dimFirst.width, dimSecond.width) + this.margins.left + this.margins.right, dimFirst.height + this.gap + dimSecond.height + this.margins.top + this.margins.bottom);
    }

    public void paint(Object object, Graphics g, Rectangle r, int state, ItemPaintSite site) {
        boolean trans;
        this.delegate1.ips = site;
        this.delegate2.ips = site;
        Rectangle rectFirst = new Rectangle();
        Rectangle rectSecond = new Rectangle();
        this.calculateRects(object, g, r, state, site, rectFirst, rectSecond);
        boolean bl = site != null ? site.isTransparent() : (trans = !this.paintBackground);
        if (!trans) {
            Color bg;
            Color oc = g.getColor();
            Color color = bg = site != null ? site.getBackground() : this.getBackground();
            if (bg == null) {
                bg = this.getBackground();
            }
            if (bg == null) {
                bg = g.getColor();
            }
            g.setColor(bg);
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(oc);
        }
        if (object instanceof Pair) {
            this.firstPainter.paint(((Pair)object).first, g, rectFirst, state, this.delegate1);
            this.secondPainter.paint(((Pair)object).second, g, rectSecond, state, this.delegate2);
        } else {
            this.firstPainter.paint(object, g, rectFirst, state, this.delegate1);
            this.secondPainter.paint(object, g, rectSecond, state, this.delegate2);
        }
    }

    public void calculateRects(Object object, Graphics graphics, Rectangle rect, int state, ItemPaintSite site, Rectangle rectFirst, Rectangle rectSecond) {
        int yOffset;
        int xOffset;
        int a;
        Dimension dimSecond;
        Dimension dimFirst;
        if (rectFirst == null || rectSecond == null) {
            throw new IllegalArgumentException(Res._NullRectangles);
        }
        this.delegate1.ips = site;
        this.delegate2.ips = site;
        if (object instanceof Pair) {
            dimFirst = this.firstPainter.getPreferredSize(((Pair)object).first, graphics, state, this.delegate1);
            dimSecond = this.secondPainter.getPreferredSize(((Pair)object).second, graphics, state, this.delegate2);
        } else {
            dimFirst = this.firstPainter.getPreferredSize(object, graphics, state, this.delegate1);
            dimSecond = this.secondPainter.getPreferredSize(object, graphics, state, this.delegate2);
        }
        int n = a = site != null ? site.getAlignment() : this.alignment;
        if (a == 0) {
            a = this.alignment;
        }
        int fullWidth = this.orientation == 1 ? Math.max(dimFirst.width, dimSecond.width) : dimFirst.width + dimSecond.width + this.gap + this.margins.left + this.margins.right;
        int fullHeight = this.orientation == 0 ? Math.max(dimFirst.height, dimSecond.height) : dimFirst.height + dimSecond.height + this.gap + this.margins.top + this.margins.bottom;
        int hAlign = a & 0xF;
        switch (hAlign) {
            default: {
                xOffset = this.margins.left;
                break;
            }
            case 2: {
                xOffset = (rect.width - fullWidth) / 2;
                break;
            }
            case 3: {
                xOffset = rect.width - fullWidth - this.margins.right;
            }
        }
        int vAlign = a & 0xF0;
        switch (vAlign) {
            default: {
                yOffset = this.margins.top;
                break;
            }
            case 32: {
                yOffset = (rect.height - fullHeight) / 2;
                break;
            }
            case 48: {
                yOffset = rect.height - fullHeight - this.margins.bottom;
            }
        }
        if (this.orientation == 0) {
            rectFirst.x = rect.x;
            rectFirst.y = rect.y + (rect.height - dimFirst.height) / 2;
            rectFirst.width = dimFirst.width;
            rectFirst.height = dimFirst.height;
            rectSecond.x = rect.x + dimFirst.width + this.gap;
            rectSecond.y = rect.y + (rect.height - dimSecond.height) / 2;
            rectSecond.width = dimSecond.width;
            rectSecond.height = dimSecond.height;
        } else {
            rectFirst.x = rect.x + (rect.width - dimFirst.width) / 2;
            rectFirst.y = rect.y;
            rectFirst.width = dimFirst.width;
            rectFirst.height = dimFirst.height;
            rectSecond.x = rect.x + (rect.width - dimSecond.width) / 2;
            rectSecond.y = rect.y + dimFirst.height + this.gap;
            rectSecond.width = dimSecond.width;
            rectSecond.height = dimSecond.height;
        }
        rectFirst.x += xOffset;
        rectFirst.y += yOffset;
        rectSecond.x += xOffset;
        rectSecond.y += yOffset;
        Rectangle r1 = new Rectangle(rectFirst);
        Rectangle r2 = new Rectangle(rectSecond);
        if (this.orientation == 0) {
            rectFirst.x = rect.x;
            rectFirst.width = r1.x + r1.width - rect.x;
            rectSecond.width = rect.x + rect.width - r2.x;
            rectFirst.y = rect.y;
            rectFirst.height = rect.height;
            rectSecond.y = rect.y;
            rectSecond.height = rect.height;
        } else {
            rectFirst.y = rect.y;
            rectFirst.height = r1.y + r1.height - rect.y;
            rectSecond.height = rect.y + rect.height - r2.y;
            rectFirst.x = rect.x;
            rectFirst.width = rect.width;
            rectSecond.x = rect.x;
            rectSecond.width = rect.width;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable<String, ItemPainter> hash = new Hashtable<String, ItemPainter>(2);
        if (this.firstPainter instanceof Serializable) {
            hash.put("1", this.firstPainter);
        }
        if (this.secondPainter instanceof Serializable) {
            hash.put("2", this.secondPainter);
        }
        s.writeObject(hash);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Hashtable hash = (Hashtable)s.readObject();
        Object data = hash.get("1");
        if (data instanceof ItemPainter) {
            this.firstPainter = (ItemPainter)data;
        }
        if ((data = hash.get("2")) instanceof ItemPainter) {
            this.secondPainter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }

    abstract class ItemPaintSiteDelegate
    implements ItemPaintSite {
        public transient ItemPaintSite ips;

        ItemPaintSiteDelegate() {
        }

        public Color getBackground() {
            return this.ips != null ? this.ips.getBackground() : null;
        }

        public Color getForeground() {
            return this.ips != null ? this.ips.getForeground() : null;
        }

        public boolean isTransparent() {
            return this.ips != null ? this.ips.isTransparent() : false;
        }

        public Font getFont() {
            return this.ips != null ? this.ips.getFont() : null;
        }

        public Insets getItemMargins() {
            return this.ips != null ? this.ips.getItemMargins() : CompositeItemPainter.this.getMargins();
        }

        public Component getSiteComponent() {
            return this.ips != null ? this.ips.getSiteComponent() : null;
        }

        public abstract int getAlignment();
    }
}

