/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.LinkedTreeIterator;
import com.borland.jbcl.model.Res;
import java.io.Serializable;
import java.util.Enumeration;

public class LinkedTreeNode
implements GraphLocation,
Serializable {
    protected LinkedTreeNode parent;
    protected LinkedTreeNode nextSibling;
    protected LinkedTreeNode firstChild;
    protected int childCount;

    public LinkedTreeNode() {
    }

    public LinkedTreeNode(LinkedTreeNode parent) {
        this.parent = parent;
    }

    public GraphLocation getParent() {
        return this.parent;
    }

    public int hasChildren() {
        return this.firstChild != null ? 1 : 0;
    }

    public GraphLocation[] getChildren() {
        GraphLocation[] children = new GraphLocation[this.childCount];
        int i = 0;
        Enumeration enumeration = this.getChildIterator();
        while (enumeration.hasMoreElements()) {
            if (i >= children.length) {
                this.childCount = i + 1;
                GraphLocation[] c = new GraphLocation[this.childCount];
                System.arraycopy(children, 0, c, 0, this.childCount - 1);
                children = c;
            }
            children[i++] = (GraphLocation)enumeration.nextElement();
        }
        return children;
    }

    public LinkedTreeNode getFirstChild() {
        return this.firstChild;
    }

    public Enumeration getChildIterator() {
        return new LinkedTreeIterator(this.firstChild);
    }

    public LinkedTreeNode getNextSibling() {
        return this.nextSibling;
    }

    public void appendChild(LinkedTreeNode newChild) {
        this.doAddChild(newChild, null);
    }

    public void insertChild(LinkedTreeNode newChild) {
        this.doAddChild(newChild, this.firstChild);
    }

    public void insertChild(LinkedTreeNode newChild, LinkedTreeNode aheadOf) {
        this.doAddChild(newChild, aheadOf);
    }

    protected void doAddChild(LinkedTreeNode newChild, LinkedTreeNode aheadOf) {
        LinkedTreeNode newChildTail = newChild;
        while (true) {
            if (newChildTail.parent == null) {
                newChildTail.setParent(this);
                ++this.childCount;
            } else if (newChildTail.parent != this) {
                throw new IllegalArgumentException(Res.bundle.format(15, new Object[]{String.valueOf(newChildTail), String.valueOf(this), String.valueOf(newChildTail.parent)}));
            }
            if (newChildTail.nextSibling == null) break;
            newChildTail = newChildTail.nextSibling;
        }
        if (this.firstChild != null && this.firstChild != aheadOf) {
            LinkedTreeNode c = this.firstChild;
            while (true) {
                if (c.nextSibling == this.firstChild) {
                    throw new IllegalStateException(Res.bundle.format(16, new Object[]{this, c}));
                }
                if (c.nextSibling == newChild) {
                    throw new IllegalStateException(Res.bundle.format(17, new Object[]{this, newChild}));
                }
                if (c.nextSibling == null || c.nextSibling == aheadOf) {
                    newChildTail.nextSibling = c.nextSibling;
                    c.nextSibling = newChild;
                    return;
                }
                c = c.nextSibling;
            }
        }
        newChildTail.nextSibling = this.firstChild;
        this.firstChild = newChild;
    }

    public void insertSibling(LinkedTreeNode newSibling) {
        LinkedTreeNode s = newSibling;
        while (true) {
            if (s.parent != null) {
                throw new IllegalArgumentException(Res.bundle.format(18, new Object[]{s, s.parent}));
            }
            if (s.nextSibling == this) {
                throw new IllegalStateException(Res.bundle.format(19, new Object[]{this, newSibling}));
            }
            s.setParent(this.parent);
            if (s.nextSibling == null) break;
            ++this.childCount;
            s = s.nextSibling;
        }
        s.nextSibling = this.nextSibling;
        this.nextSibling = newSibling;
    }

    public void removeChild(LinkedTreeNode unwantedChild) {
        if (this.firstChild == unwantedChild) {
            this.firstChild = unwantedChild.nextSibling;
        } else if (this.firstChild != null) {
            LinkedTreeNode c = this.firstChild;
            while (true) {
                if (c.nextSibling == unwantedChild) {
                    c.nextSibling = unwantedChild.nextSibling;
                    break;
                }
                if (c.nextSibling == null) {
                    throw new IllegalArgumentException(Res.bundle.format(20, new Object[]{unwantedChild, this}));
                }
                c = c.nextSibling;
            }
        }
        unwantedChild.setParent(null);
        unwantedChild.nextSibling = null;
        --this.childCount;
    }

    public LinkedTreeNode removeNode(LinkedTreeNode root) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else if (this == root) {
            root = this.nextSibling;
        } else {
            LinkedTreeNode lastSibling = root;
            while (lastSibling.nextSibling != this) {
                lastSibling = lastSibling.nextSibling;
            }
            lastSibling.nextSibling = this.nextSibling;
        }
        this.nextSibling = null;
        return root;
    }

    protected void setParent(LinkedTreeNode parent) {
        this.parent = parent;
    }

    public void print() {
        this.print(0);
    }

    public void print(int level) {
        for (int i = 0; i < 2 * level; ++i) {
            System.err.print(" ");
        }
        System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this))).append(" L").append(level))));
        if (this.firstChild != null) {
            this.firstChild.print(level + 1);
        }
        if (this.nextSibling != null) {
            this.nextSibling.print(level);
        }
    }

    public void check() {
        LinkedTreeNode c = this.firstChild;
        while (c != null) {
            if (c.parent != this) {
                throw new IllegalStateException(Res.bundle.format(21, new Object[]{c, this}));
            }
            if (c.nextSibling == this.firstChild) {
                throw new IllegalStateException(Res.bundle.format(16, new Object[]{this, c}));
            }
            c = c.nextSibling;
        }
    }
}

